//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: 
//****************************************** 
/*							Pin Assignment
*********************************************************************
.........................-----------------............................
01.VSS.................01|O              |16.VDD
02.P00/XIN.............02|               |15.P40/AIN0/KWI0
03.P01/XOUT............03|     QFN-16    |14.P41/AIN1/KWI1
04.P10/RESETB..........04|               |13.P42/AIN2/KWI2
05.P71/TC01/PWM01B.....05|               |12.P43/AIN3/KWI3/VREF
06.P90/TX/RX...........06|     LQFP-16   |11.P74/DVOB/AIN8/SI/KWI13      
07.P91/RX/TX...........07|               |10.P76/INT3/SCLK/KWI15
08.P72/TCA0/PPGA0B.....08|	             |9.P70/TC00/PWM00B               
.........................-----------------............................
*********************************************************************/
//******************************************
//Stack Pointer	=	0x23f (If use mq6821_x_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6821.h"
#include "MQ6812_REG_BIT.h"
#include "ADC_Function.h"

unsigned int ADC_VALUE_READ;
void main()
{

	//====================
	// set ADC config
	//====================
/***************************************
 * 
 * function :void adc_config_set(unsigned char,unsigned char,unsigned char,unsigned char)
 * 
 * *************************************/

// /******************
//  * 1st Argument
//  * ****************/
// ADC_Single		0x1		single mode
// ADC_Repeat		0x3		repeat mode	
// /******************
//  * 2nd Argument
//  * ****************/
// AIN_EN			0x1		analog input enable	
// AIN_DIS			0x0		analog input disable
// /******************
//  * 3rd Argument
//  * ****************/
// AIN0			0x0     	set analog input channel to AIN0
// AIN1			0x1			set analog input channel to AIN1
// AIN2			0x2			set analog input channel to AIN2
// AIN3			0x3			set analog input channel to AIN3
// AIN4			0x4			set analog input channel to AIN4
// AIN5			0x5			set analog input channel to AIN5
// AIN6			0x6			set analog input channel to AIN6
// AIN7			0x7			set analog input channel to AIN7
// AIN8			0x8			set analog input channel to AIN8
// VDD4_1		0x9			set analog input channel to internal 1/4 VDD input
// AIN_GND      0xc         set analog input channel to internal ground
// /******************
//  * 4th Argument
//  * ****************/
// Conv32CLK		0x0		AD conversion times-32 fcgck
// Conv64CLK		0x1		AD conversion times-64 fcgck
// Conv128CLK		0x2		AD conversion times-128 fcgck
// Conv256CLK		0x3		AD conversion times-256 fcgck
// Conv512CLK		0x4		AD conversion times-512 fcgck
// Conv1024CLK		0x5 	set conversion times to 1024 fcgck
//                          (*conversion times must be between 12.8 us to 128 us)
// /******************
//  * 5th Argument
//  * ****************/
// Vref2			0x0		set ADC reference voltage to internal 2V
// Vref3			0x1		set ADC reference voltage to internal 3V
// Vref4			0x2		set ADC reference voltage to internal 4V
// VDDVref			0x3		set ADC reference voltage to internal VDD
// EXTVref			0x4		set ADC reference voltage to external voltage (AIN3)
//                           when AIN3 is used as the external voltage input, AIN3 cannot be used to analog input


	
	//set repeat mode,AIN7 input and enable,Convert time 128/fcgck,VddVref
	adc_config_set(ADC_Repeat,AIN_EN,AIN7,Conv128CLK,VDDVref);	
	
	//====================
	// start ADC
	//====================
	adc_start();
	
	//====================
	// looop
	//====================
	while(1)
	{
	
		while(ADC_EndFlag !=1)
		{
			WDCDR.byte = 0x4e;
		}

		ADC_VALUE_READ = adc_result_read();

	}

}


